clear all; close all; clc;

load('Capacity_SNR.mat');

C = linspecer(5);

figure;
box on; grid on; hold on;
plot(SNR,SumRate,'--k','LineWidth',1.5);
plot(SNR,SumRate_GPR,'-d','LineWidth',1.5,'Color',C(1,:));
plot(SNR,SumRate_exp,'-r>','LineWidth',1.5,'Color',C(2,:));
plot(SNR,SumRate_LMMSE,'-p','LineWidth',1.5,'Color',C(5,:));
plot(SNR,SumRate_ML,'-o','LineWidth',1.5,'Color',C(3,:));
plot(SNR,SumRate_OMP,'-s','LineWidth',1.5,'Color',C(4,:));

legend('完美CSI','所提出的S-BAR（协方差核）','所提出的S-BAR（指数核）', ...
   '串行插值估计器', '最大似然估计器', 'OMP估计器','FontSize',12);
xlabel('信道估计时的接收机SNR (dB)','FontSize',14);
ylabel('频谱效率 (bps/Hz)','FontSize',14);
